document.addEventListener('DOMContentLoaded', () => {
    // --- 1. Animasi Fade-in saat Scroll (Intersection Observer) ---
    const animatedElements = document.querySelectorAll('.animated-on-scroll');
    
    const observerOptions = {
        root: null, // Menggunakan viewport
        threshold: 0.1 // Mulai tampil saat 10% elemen terlihat
    };

    const observer = new IntersectionObserver((entries, observer) => {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                entry.target.classList.add('is-visible');
                observer.unobserve(entry.target); // Stop mengamati setelah animasi pertama
            }
        });
    }, observerOptions);

    animatedElements.forEach(el => {
        observer.observe(el);
    });

    // --- 2. Tambahan: Efek Aktif Navigasi berdasarkan URL (opsional) ---
    const navLinks = document.querySelectorAll('.main-nav ul li a');
    const currentPath = window.location.pathname.split('/').pop();

    navLinks.forEach(link => {
        if (link.getAttribute('href') === currentPath || (currentPath === '' && link.getAttribute('href') === 'index.php')) {
            link.style.fontWeight = 'bold'; // Contoh sederhana penanda aktif
        }
    });

});